/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (09/05/07)
 */    
package com.ejie.p06b.util;

import java.util.Locale;
import java.util.ResourceBundle;

import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.log.P06BLog;



/**
 *  Esta clase representa una configuracin especfica para una regin.
 */
public class P06BResources {
	
    private ResourceBundle cRecursos = null;
  
    private Locale locale = Locale.getDefault();
    private String cresName = P06BConstantes.P06B_RES_ETIQUETAS;
    
    /**
     *  Construye un nueva configuracin de regin.
     */
    public P06BResources() {
    }
  
    /**
     *  Construye un nueva configuracin de regin con una configuracin loc
     *  @param  loc     configuracion local
     */
    public P06BResources(Locale loc) {
    	locale = loc;
    }

    /**
     *  Construye un nueva configuracin de regin con una configuracin loc
     *  y un fichero de configuracin resName
     *  @param  loc     configuracion local.
     *  @param  resName fichero de configuracin.
     */
    public P06BResources(Locale loc, String resName) {
  	    locale = loc;
    	cresName = resName;
    }          
    
    /**
     *  Obtiene una caracterstica astrClave de la configuracin regional.
     *  @param  String  valor de la caracterstica buscada.
     */
    public String get(String astrClave) {
	    String lstrValor = "";
	  
	    try {    
	  	    loadResources();           
	  	    lstrValor = cRecursos.getString (astrClave);
	    } catch (Exception e) {
            P06BLog.send(2,this.getClass().getName(),"P06B - REFERENCIA ERRONEA EN FICHERO DE CONFIGURACION");
        }
	    
	  return lstrValor;
    }
    
    /**
     *  Carga una configuracin de regin a partir de los parmetros definidos
     *  de regin y fichero de configuracin.
     */
    private void loadResources() {
  	    if (cRecursos == null)  {
  		    cRecursos = ResourceBundle.getBundle(cresName,locale);
  	    }
    }   
}
